#ifndef CYPRESS_OPERATING_MODE_H_
#define CYPRESS_OPERATING_MODE_H_

/*
#define REP_LEN           0x00
*/
#define CMD_DATA          0x01
#define REP_STAT          0x01
#define REP_COUNTER       0xC0
#define REP_INVALID       0x20
#define REP_NOISE_EFTS    0x1C
#define RTD_FAIL_STATUS   0x01
#define RTD_CRC           0x00
#define RTD_COUNTER       0x28
#define RTD_GPIO_OPEN_ERR 0x29
#define REP_RTD_UPDATE    0x02
#define BUTTONS0          0x02
#define BUTTONS1          0x03
#define BUTTONS2          0x04
#define BUTTONS3          0x05
/*
#define GEST_ID           0x02
#define GEST_CNT          0x03
#define TT_STAT_OFS       0x05
#define OBJ_CFG0          0x06
#define MAX_TCHS          0x07
#define TCH_REC_SIZ       0x08
#define TCH_REC_0         0x09
#define TCH_REC_1         0x0A
#define TCH_REC_2         0x0B
#define TCH_REC_3         0x0C
#define TCH_REC_4         0x0D
#define TCH_REC_5         0x0E
#define TCH_REC_6         0x0F
#define TCH_REC_7         0x10
#define TCH_REC_8         0x11
#define TCH_REC_9         0x12
#define TCH_REC_10        0x13
#define TCH_REC_11        0x14
#define TCH_REC_12        0x15
#define TCH_REC_13        0x16
#define BTN_REC_SIZ       0x17
#define BTN_DIFF_OFS      0x18
#define BTN_DIFF_SIZ      0x19
#define TCH_REC_14        0x1A
#define TCH_REC_15        0x1B
#define TCH_REC_16        0x1C
#define TCH_REC_17        0x1D
#define TCH_REC_18        0x1E
#define TCH_REC_19        0x1F
#define NOISE_DATA_OFS    0x20
#define NOISE_DATA_SZ     0x21
*/

/* TT_STAT Offsets */
#define TOUCH_RECORDS        0x01

/* Event ID (status) */
#define NO_EVENT             0
#define TOUCH_PRESS          1
#define TOUCH_MOVE           2
#define TOUCH_RELEASE        3

/* Touch ID / Type */
#define FINGER               0
#define LARGE_OBJECT         1


/* Operating Mode commands */
#define CYPRESS_OPERATING_MODE_PING                         0x00
#define CYPRESS_OPERATING_PLAY_HATPIC_DATA                  0x26
/* Reserved                                                 0x01    */
#define CYPRESS_OPERATING_MODE_GET_PARAMETER                0x02
#define CYPRESS_OPERATING_MODE_GET_PARAMETER_REPLY_LEN      6       * Likely not 6 bytes, however we read the max and use the size param returned to figure that out */
#define CYPRESS_OPERATING_MODE_SET_PARAMETER                0x03
#define CYPRESS_OPERATING_MODE_SET_PARAMETER_REPLY_LEN      2
/* Reserved                                                 0x04    */
#define CYPRESS_OPERATING_MODE_GET_DATA_BLOCK_CRC           0x05
/* Reserved                                                 0x06 - 0xFF */
/* Play Haptic Effect*/
#define CYPRESS_OPERATING_PLAY_HAPTIC_RET_SZ            1
/* Offsets */
#define CYPRESS_OPERATING_MODE_PARAM_ID_OFFSET      0
#define CYPRESS_OPERATING_MODE_PARAM_SIZE_OFFSET    1
#define CYPRESS_OPERATING_MODE_PARAM_DATA_OFFSET    1


/* Configurable Register details */
typedef struct {
    uint8_t addr;
    uint8_t size;
    int min;
    int max;
} _opm_reg_t;

typedef enum {
    /* Gen 4 Configurable Registers [RAM] ID's */
    ACT_DIST0 = 0,
    LP_INTRVL0,
    ACT_INTRVL0,
    TCH_TMOUT0,
    ACT_DIST2,
    ACT_LFT_INTVL0,
    CA_HOST_CONTROLLED_NOISE_ACTION,
    FINGER_THRESH_MUTUAL,
    TSS_SEQ_CONFIG4_SELF_RAMP_INT_UP,
    TSS_SEQ_CONFIG4_MUT_RAMP_INT_UP,
    /* Gen 6 Configurable Registers [RAM] ID's */
    /* Parameters in RAM Only */
    CHARGER_STATUS,
    FORCE_SINGLE_TX,
    /* Parameters in RAM with Default Value in FLASH */
    WATER_REJ_ENABLE,
    CHARGER_ARMOR_ENABLE,
    TOUCHMODE_CONFIG,
    CA_WB_THRESH,
    CA_NMI_THRESH,
    ACT_LFT_EN,
    ACT_LFT_INTRVL0,
    TX_PERIOD_MC,
    LOW_POWER_ENABLE,
    FINGER_ID_MAX_FINGER_VELOCITY2,
    FINGER_ID_MAX_FINGER_ACCELERATION2,
    GRIP_XEDG_A,
    GRIP_XEDG_B,
    GRIP_XEXC_A,
    GRIP_XEXC_B,
    GRIP_YEDG_A,
    GRIP_YEDG_B,
    GRIP_YEXC_A,
    GRIP_YEXC_B,
    GRIP_FIRST_EXC,
    GRIP_EXC_EDGE_ORIGIN,
    GRIP_ENABLE,
    SIZE_ORIENTATION_ENABLE,
    GEST_PAN_ACTIVE_DISTANCE_X,
    GEST_PAN_ACTIVE_DISTANCE_Y,
    GEST_ZOOM_ACTIVE_DISTANCE,
    GEST_FLICK_ACTIVE_DISTANCE_X,
    GEST_FLICK_ACTIVE_DISTANCE_Y,
    GEST_MULTITOUCH_ROTATION_THRESHOLD,
    GEST_ST_MAX_DOUBLE_CLICK_RADIUS,
    GEST_ST_MAX_CLICK_TIMEOUT_MSEC,
    GEST_ST_MAX_DOUBLECLICK_TIMEOUT_MSEC,
    GEST_RIGHTCLICK_MAX_TIMEOUT_MSEC,
    GEST_GROUP_MASK,
    XY_AXES_FLIP_ROTATE_CFG,
} operating_mode_reg;

static const _opm_reg_t gen4_operating_mode_reg_cfg[] =
{
    {0x4A, 1, 0, 15},       // ACT_DIST0
    {0x4C, 2, 0, 250},      // LP_INTRVL0
    {0x4D, 1, 0, 250},      // ACT_INTRVL0
    {0x4E, 2, 0, 1000},     // TCH_TMOUT0
    {0x50, 1, 0, 15},       // ACT_DIST2
    {0x4F, 1, 0, 250},      // ACT_LFT_INTVL0
    {0x51, 1, 0, 1},        // CA_HOST_CONTROLLED_NOISE_ACTION
    {0x93, 2, 1, 2000},     // FINGER_THRESH_MUTUAL
    {0x9C, 1, 0, 255},      // TSS_SEQ_CONFIG4_SELF_RAMP_INT_UP
    {0x9D, 1, 0, 255},      // TSS_SEQ_CONFIG4_MUT_RAMP_INT_UP
};

static const _opm_reg_t gen6_operating_mode_reg_cfg[] =
{
    {0x0A, 1, -1, -1},      // ACT_DIST0
    {0x19, 2, -1, -1},      // LP_INTRVL0
    {0x1B, 1, -1, -1},      // ACT_INTRVL0
    {0x1C, 2, -1, -1},      // TCH_TMOUT0
    {0x0B, 1, -1, -1},      // ACT_DIST2
    {0x00, 0,  0,  0},      //
    {0x00, 0,  0,  0},      //
    {0x00, 0,  0,  0},      //  Gen 4 only Commands
    {0x00, 0,  0,  0},      //
    {0x00, 0,  0,  0},      //
    {0x09, 1, -1, -1},      // CHARGER_STATUS
    {0x1F, 1, -1, -1},      // FORCE_SINGLE_TX
    {0x05, 1, -1, -1},      // WATER_REJ_ENABLE
    {0x04, 1, -1, -1},      // CHARGER_ARMOR_ENABLE
    {0x02, 1, -1, -1},      // TOUCHMODE_CONFIG
    {0x07, 2, -1, -1},      // CA_WB_THRESH
    {0x08, 2, -1, -1},      // CA_NMI_THRESH
    {0x1A, 1, -1, -1},      // ACT_LFT_EN
    {0x1D, 2, -1, -1},      // ACT_LFT_INTRVL0
    {0x20, 2, -1, -1},      // TX_PERIOD_MC
    {0x06, 1, -1, -1},      // LOW_POWER_ENABLE
    {0x0D, 4, -1, -1},      // FINGER_ID_MAX_FINGER_VELOCITY2
    {0x24, 4, -1, -1},      // FINGER_ID_MAX_FINGER_ACCELERATION2
    {0x0E, 2, -1, -1},      // GRIP_XEDG_A
    {0x0F, 2, -1, -1},      // GRIP_XEDG_B
    {0x10, 2, -1, -1},      // GRIP_XEXC_A
    {0x11, 2, -1, -1},      // GRIP_XEXC_B
    {0x12, 2, -1, -1},      // GRIP_YEDG_A
    {0x13, 2, -1, -1},      // GRIP_YEDG_B
    {0x14, 2, -1, -1},      // GRIP_YEXC_A
    {0x15, 2, -1, -1},      // GRIP_YEXC_B
    {0x16, 1, -1, -1},      // GRIP_FIRST_EXC
    {0x17, 1, -1, -1},      // GRIP_EXC_EDGE_ORIGIN
    {0x18, 1, -1, -1},      // GRIP_ENABLE
    {0x0C, 1, -1, -1},      // SIZE_ORIENTATION_ENABLE
    {0x29, 1, -1, -1},      // GEST_PAN_ACTIVE_DISTANCE_X
    {0x2A, 1, -1, -1},      // GEST_PAN_ACTIVE_DISTANCE_Y
    {0x2E, 1, -1, -1},      // GEST_ZOOM_ACTIVE_DISTANCE
    {0x2B, 1, -1, -1},      // GEST_FLICK_ACTIVE_DISTANCE_X
    {0x2C, 1, -1, -1},      // GEST_FLICK_ACTIVE_DISTANCE_Y
    {0x2D, 1, -1, -1},      // GEST_MULTITOUCH_ROTATION_THRESHOLD
    {0x28, 1, -1, -1},      // GEST_ST_MAX_DOUBLE_CLICK_RADIUS
    {0x26, 2, -1, -1},      // GEST_ST_MAX_CLICK_TIMEOUT_MSEC
    {0x27, 2, -1, -1},      // GEST_ST_MAX_DOUBLECLICK_TIMEOUT_MSEC
    {0x2F, 2, -1, -1},      // GEST_RIGHTCLICK_MAX_TIMEOUT_MSEC
    {0x25, 2, -1, -1},      // GEST_GROUP_MASK
    {0x30, 1, -1, -1},      // XY_AXES_FLIP_ROTATE_CFG
};

typedef struct touch_report {
    uint16_t x;
    uint16_t y;
    uint8_t z;
    uint8_t id;
    uint8_t status;
    uint8_t touch_type;
    uint8_t touch_type2;
    uint8_t pressure;
    uint8_t width;
    uint8_t height;
    uint8_t orientation;
} touch_report_t;

typedef struct operating_mode_report {
    uint8_t rep_len;
    uint8_t rep_stat;
    uint8_t buttons0;
    uint8_t buttons1;
    uint8_t buttons2;
    uint8_t buttons3;
    uint8_t gest_id;
    uint8_t gest_cnt;
    uint16_t noise_level;
    uint16_t noise_level_velocity;
    uint16_t activated_sensors;
    uint16_t common_mode_metric;
    uint16_t active_fh_freqency;
    uint8_t tt_stat;
    uint8_t *touch_records;
    uint8_t *button_data;
} operating_mode_report_t;

#endif /* CYPRESS_OPERATING_MODE_H_ */

#if defined(__QNXNTO__) && defined(__USESRCVERSION)
#include <sys/srcversion.h>
__SRCVERSION("$URL: http://svn.ott.qnx.com/product/branches/7.0.0/trunk/hardware/mtouch/cypress/operating_mode.h $ $Rev: 871068 $")
#endif
